from mongoengine import Document, StringField, DateTimeField, DictField
from datetime import datetime
import uuid


class ActionLog(Document):
    """Action Log model for audit trail"""
    meta = {'collection': 'action_logs'}

    action_log_id = StringField(required=True, unique=True, default=lambda: str(uuid.uuid4()))
    user_id = StringField()
    action_type = StringField(required=True)  # login, logout, create, update, delete, etc.
    entity_type = StringField()  # user, case, document, etc.
    entity_id = StringField()
    ip_address = StringField()
    user_agent = StringField()
    request_data = DictField()
    response_status = StringField()
    error_details = DictField()
    timestamp = DateTimeField(default=datetime.utcnow)
    created_at = DateTimeField(default=datetime.utcnow)

    def __repr__(self):
        return f'<ActionLog {self.action_log_id}>'
