from mongoengine import Document, StringField, DateTimeField, IntField, BooleanField
from datetime import datetime
import uuid


class Announcement(Document):
    """Announcement model for system announcements"""
    meta = {'collection': 'announcements'}

    # Primary fields
    announcement_id = StringField(required=True, unique=True, default=lambda: str(uuid.uuid4()))
    title = StringField(required=True)
    message = StringField(required=True)

    # Status
    status = StringField(required=True, choices=['active', 'archived'], default='active')

    # Tracking
    view_count = IntField(default=0)
    created_by = StringField(required=True)  # Admin user ID
    created_by_name = StringField()  # Admin name for display
    updated_by = StringField()

    # Soft delete
    is_deleted = BooleanField(default=False)
    deleted_at = DateTimeField()
    deleted_by = StringField()

    # Timestamps
    created_at = DateTimeField(default=datetime.utcnow)
    updated_at = DateTimeField(default=datetime.utcnow)

    def __repr__(self):
        return f'<Announcement {self.title}>'

    def increment_view_count(self):
        """Increment view count when announcement is viewed"""
        self.view_count += 1
        self.save()
