import smtplib
from email.mime.text import MIMEText
from email.mime.multipart import MIMEMultipart
from datetime import datetime


class EmailConfig:
    """Email configuration"""
    EMAIL_FROM = "noreplyf@vidushiinfotech.net"
    EMAIL_HOST = "mail.vidushiinfotech.net"
    EMAIL_PORT = 25
    EMAIL_USERNAME = "noreplyf@vidushiinfotech.net"
    EMAIL_PASSWORD = "4Qplr06@"
    IS_SSL = False


def send_password_reset_email(to_email, full_name, new_password):
    """
    Send password reset notification email

    Args:
        to_email (str): Recipient email address
        full_name (str): User's full name
        new_password (str): New password

    Returns:
        tuple: (success: bool, message: str)
    """
    try:
        # Create message
        msg = MIMEMultipart('alternative')
        msg['Subject'] = 'Password Reset Notification - imCode'
        msg['From'] = EmailConfig.EMAIL_FROM
        msg['To'] = to_email

        # Email body
        text_body = f"""
Dear {full_name},

Your password has been reset by an administrator.

Your new password is: {new_password}

For security reasons, we recommend that you change this password after logging in.

Login URL: https://imcode.viewmysitenow.com

If you did not request this password reset, please contact support immediately.

Best regards,
imCode Team

---
This is an automated message. Please do not reply to this email.
Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC
"""

        html_body = f"""
<!DOCTYPE html>
<html>
<head>
    <style>
        body {{ font-family: Arial, sans-serif; line-height: 1.6; color: #333; }}
        .container {{ max-width: 600px; margin: 0 auto; padding: 20px; }}
        .header {{ background-color: #4CAF50; color: white; padding: 20px; text-align: center; }}
        .content {{ background-color: #f9f9f9; padding: 20px; border: 1px solid #ddd; }}
        .password-box {{ background-color: #fff3cd; border: 2px solid #ffc107; padding: 15px; margin: 20px 0; text-align: center; font-size: 18px; font-weight: bold; }}
        .footer {{ background-color: #f1f1f1; padding: 15px; text-align: center; font-size: 12px; color: #666; }}
        .button {{ display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 5px; margin: 10px 0; }}
        .warning {{ color: #d9534f; font-weight: bold; }}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Password Reset Notification</h1>
        </div>
        <div class="content">
            <p>Dear <strong>{full_name}</strong>,</p>

            <p>Your password has been reset by an administrator.</p>

            <div class="password-box">
                Your new password is: {new_password}
            </div>

            <p class="warning">⚠️ For security reasons, we recommend that you change this password after logging in.</p>

            <p style="text-align: center;">
                <a href="https://imcode.viewmysitenow.com" class="button">Login to imCode</a>
            </p>

            <p>If you did not request this password reset, please contact support immediately.</p>

            <p>Best regards,<br>
            <strong>imCode Team</strong></p>
        </div>
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC</p>
        </div>
    </div>
</body>
</html>
"""

        # Attach both plain text and HTML versions
        part1 = MIMEText(text_body, 'plain')
        part2 = MIMEText(html_body, 'html')
        msg.attach(part1)
        msg.attach(part2)

        # Send email
        if EmailConfig.IS_SSL:
            server = smtplib.SMTP_SSL(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)
        else:
            server = smtplib.SMTP(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)

        # Login if username and password are provided
        if EmailConfig.EMAIL_USERNAME and EmailConfig.EMAIL_PASSWORD:
            server.login(EmailConfig.EMAIL_USERNAME, EmailConfig.EMAIL_PASSWORD)

        # Send email
        server.sendmail(EmailConfig.EMAIL_FROM, to_email, msg.as_string())
        server.quit()

        return True, "Email sent successfully"

    except smtplib.SMTPAuthenticationError:
        return False, "SMTP authentication failed. Please check email credentials."
    except smtplib.SMTPException as e:
        return False, f"SMTP error occurred: {str(e)}"
    except Exception as e:
        return False, f"Failed to send email: {str(e)}"


def send_otp_email(to_email, full_name, otp_code, otp_validity_minutes=10):
    """
    Send OTP email for password reset

    Args:
        to_email (str): Recipient email address
        full_name (str): User's full name
        otp_code (str): OTP code
        otp_validity_minutes (int): OTP validity in minutes

    Returns:
        tuple: (success: bool, message: str)
    """
    try:
        # Create message
        msg = MIMEMultipart('alternative')
        msg['Subject'] = 'Password Reset OTP - imCode'
        msg['From'] = EmailConfig.EMAIL_FROM
        msg['To'] = to_email

        # Email body
        text_body = f"""
Dear {full_name},

We received a request to reset your password for your imCode account.

Your OTP code is: {otp_code}

This OTP is valid for {otp_validity_minutes} minutes.

If you did not request this password reset, please ignore this email or contact support if you have concerns.

Best regards,
imCode Team

---
This is an automated message. Please do not reply to this email.
Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC
"""

        html_body = f"""
<!DOCTYPE html>
<html>
<head>
    <style>
        body {{ font-family: Arial, sans-serif; line-height: 1.6; color: #333; }}
        .container {{ max-width: 600px; margin: 0 auto; padding: 20px; }}
        .header {{ background-color: #2196F3; color: white; padding: 20px; text-align: center; }}
        .content {{ background-color: #f9f9f9; padding: 20px; border: 1px solid #ddd; }}
        .otp-box {{ background-color: #e3f2fd; border: 3px solid #2196F3; padding: 20px; margin: 20px 0; text-align: center; font-size: 32px; font-weight: bold; letter-spacing: 8px; color: #1976D2; }}
        .footer {{ background-color: #f1f1f1; padding: 15px; text-align: center; font-size: 12px; color: #666; }}
        .warning {{ color: #d9534f; font-weight: bold; }}
        .info-box {{ background-color: #fff3cd; border-left: 4px solid #ffc107; padding: 10px; margin: 15px 0; }}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 Password Reset Request</h1>
        </div>
        <div class="content">
            <p>Dear <strong>{full_name}</strong>,</p>

            <p>We received a request to reset your password for your imCode account.</p>

            <p><strong>Your One-Time Password (OTP) is:</strong></p>

            <div class="otp-box">
                {otp_code}
            </div>

            <div class="info-box">
                <p style="margin: 0;">⏰ This OTP is valid for <strong>{otp_validity_minutes} minutes</strong></p>
            </div>

            <p>Please enter this OTP in the password reset form to proceed.</p>

            <p class="warning">⚠️ If you did not request this password reset, please ignore this email or contact support if you have concerns.</p>

            <p>Best regards,<br>
            <strong>imCode Team</strong></p>
        </div>
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC</p>
        </div>
    </div>
</body>
</html>
"""

        # Attach both plain text and HTML versions
        part1 = MIMEText(text_body, 'plain')
        part2 = MIMEText(html_body, 'html')
        msg.attach(part1)
        msg.attach(part2)

        # Send email
        if EmailConfig.IS_SSL:
            server = smtplib.SMTP_SSL(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)
        else:
            server = smtplib.SMTP(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)

        # Login if username and password are provided
        if EmailConfig.EMAIL_USERNAME and EmailConfig.EMAIL_PASSWORD:
            server.login(EmailConfig.EMAIL_USERNAME, EmailConfig.EMAIL_PASSWORD)

        # Send email
        server.sendmail(EmailConfig.EMAIL_FROM, to_email, msg.as_string())
        server.quit()

        return True, "Email sent successfully"

    except smtplib.SMTPAuthenticationError:
        return False, "SMTP authentication failed. Please check email credentials."
    except smtplib.SMTPException as e:
        return False, f"SMTP error occurred: {str(e)}"
    except Exception as e:
        return False, f"Failed to send email: {str(e)}"


def send_password_reset_success_email(to_email, full_name):
    """
    Send password reset success notification email

    Args:
        to_email (str): Recipient email address
        full_name (str): User's full name

    Returns:
        tuple: (success: bool, message: str)
    """
    try:
        # Create message
        msg = MIMEMultipart('alternative')
        msg['Subject'] = 'Password Reset Successful - imCode'
        msg['From'] = EmailConfig.EMAIL_FROM
        msg['To'] = to_email

        # Email body
        text_body = f"""
Dear {full_name},

Your password has been successfully reset.

If you did not perform this action, please contact support immediately.

For your security:
- Never share your password with anyone
- Use a strong, unique password
- Change your password regularly

Login URL: https://imcode.viewmysitenow.com

Best regards,
imCode Team

---
This is an automated message. Please do not reply to this email.
Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC
"""

        html_body = f"""
<!DOCTYPE html>
<html>
<head>
    <style>
        body {{ font-family: Arial, sans-serif; line-height: 1.6; color: #333; }}
        .container {{ max-width: 600px; margin: 0 auto; padding: 20px; }}
        .header {{ background-color: #4CAF50; color: white; padding: 20px; text-align: center; }}
        .content {{ background-color: #f9f9f9; padding: 20px; border: 1px solid #ddd; }}
        .success-box {{ background-color: #d4edda; border: 2px solid #28a745; padding: 15px; margin: 20px 0; text-align: center; color: #155724; }}
        .footer {{ background-color: #f1f1f1; padding: 15px; text-align: center; font-size: 12px; color: #666; }}
        .button {{ display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 5px; margin: 10px 0; }}
        .warning {{ color: #d9534f; font-weight: bold; }}
        .tips {{ background-color: #e7f3ff; border-left: 4px solid #2196F3; padding: 15px; margin: 15px 0; }}
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>✅ Password Reset Successful</h1>
        </div>
        <div class="content">
            <p>Dear <strong>{full_name}</strong>,</p>

            <div class="success-box">
                <h2 style="margin: 0;">Your password has been successfully reset!</h2>
            </div>

            <p class="warning">⚠️ If you did not perform this action, please contact support immediately.</p>

            <div class="tips">
                <h3 style="margin-top: 0;">Security Tips:</h3>
                <ul style="margin-bottom: 0;">
                    <li>Never share your password with anyone</li>
                    <li>Use a strong, unique password</li>
                    <li>Change your password regularly</li>
                    <li>Enable two-factor authentication if available</li>
                </ul>
            </div>

            <p style="text-align: center;">
                <a href="https://imcode.viewmysitenow.com" class="button">Login to imCode</a>
            </p>

            <p>Best regards,<br>
            <strong>imCode Team</strong></p>
        </div>
        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
            <p>Generated at: {datetime.utcnow().strftime('%Y-%m-%d %H:%M:%S')} UTC</p>
        </div>
    </div>
</body>
</html>
"""

        # Attach both plain text and HTML versions
        part1 = MIMEText(text_body, 'plain')
        part2 = MIMEText(html_body, 'html')
        msg.attach(part1)
        msg.attach(part2)

        # Send email
        if EmailConfig.IS_SSL:
            server = smtplib.SMTP_SSL(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)
        else:
            server = smtplib.SMTP(EmailConfig.EMAIL_HOST, EmailConfig.EMAIL_PORT)

        # Login if username and password are provided
        if EmailConfig.EMAIL_USERNAME and EmailConfig.EMAIL_PASSWORD:
            server.login(EmailConfig.EMAIL_USERNAME, EmailConfig.EMAIL_PASSWORD)

        # Send email
        server.sendmail(EmailConfig.EMAIL_FROM, to_email, msg.as_string())
        server.quit()

        return True, "Email sent successfully"

    except smtplib.SMTPAuthenticationError:
        return False, "SMTP authentication failed. Please check email credentials."
    except smtplib.SMTPException as e:
        return False, f"SMTP error occurred: {str(e)}"
    except Exception as e:
        return False, f"Failed to send email: {str(e)}"
