"""
Seed script to add test admin and user data to MongoDB
"""
from app.models.user import User
from mongoengine import connect
import os
from dotenv import load_dotenv

load_dotenv()

# Connect to MongoDB
MONGO_URI = os.getenv('MONGO_URI', 'mongodb+srv://imCode:india1234@imcode.i5qtdxi.mongodb.net/')
connect(host=MONGO_URI)

print("🔄 Seeding database with test data...")

# Clear existing users (optional - comment out if you want to keep existing data)
# User.objects.delete()

# Create Admin User
admin_exists = User.objects(email='admin@imcode.com').first()
if not admin_exists:
    admin = User(
        email='admin@imcode.com',
        password='admin123',  # No encryption as per requirement
        full_name='Admin User',
        user_type='AD',
        phone='+91-9876543210',
        is_active=True,
        is_verified=True,
        profile_data={'department': 'Administration'}
    )
    admin.save()
    print(f"✅ Admin created: {admin.email} (user_id: {admin.user_id})")
else:
    print(f"⚠️  Admin already exists: {admin_exists.email}")

# Create Regular User
user_exists = User.objects(email='user@imcode.com').first()
if not user_exists:
    user = User(
        email='user@imcode.com',
        password='user123',  # No encryption as per requirement
        full_name='John Doe',
        user_type='US',
        phone='+91-9876543211',
        is_active=True,
        is_verified=True,
        profile_data={'department': 'Legal'}
    )
    user.save()
    print(f"✅ User created: {user.email} (user_id: {user.user_id})")
else:
    print(f"⚠️  User already exists: {user_exists.email}")

# Create another test user
user2_exists = User.objects(email='test@imcode.com').first()
if not user2_exists:
    user2 = User(
        email='test@imcode.com',
        password='test123',  # No encryption as per requirement
        full_name='Jane Smith',
        user_type='US',
        phone='+91-9876543212',
        is_active=True,
        is_verified=True,
        profile_data={'department': 'Operations'}
    )
    user2.save()
    print(f"✅ User created: {user2.email} (user_id: {user2.user_id})")
else:
    print(f"⚠️  User already exists: {user2_exists.email}")

print("\n🎉 Database seeding completed!")
print("\n📋 Test Credentials:")
print("=" * 50)
print("Admin Login:")
print("  Email: admin@imcode.com")
print("  Password: admin123")
print("  User Type: AD")
print()
print("User Login 1:")
print("  Email: user@imcode.com")
print("  Password: user123")
print("  User Type: US")
print()
print("User Login 2:")
print("  Email: test@imcode.com")
print("  Password: test123")
print("  User Type: US")
print("=" * 50)
print("\n🌐 Test the API at:")
print("  Swagger UI: http://127.0.0.1:5000/api/docs")
print("  Login API: POST http://127.0.0.1:5000/api/v1/login")
